
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("PaintMixing")

# Create decision variables
iota = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iota")  # Cans of Iota paint
lambda_ = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lambda_")  # Cans of Lambda paint


# Set objective function: Minimize cost
model.setObjective(8 * iota + 12 * lambda_, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * iota + 5 * lambda_ >= 10, "dye_constraint")
model.addConstr(5 * iota + 8 * lambda_ >= 12, "thinner_constraint")
model.addConstr(6 * iota + 3 * lambda_ >= 15, "oil_constraint")


# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Minimum cost: ${model.objVal:.2f}")
    print(f"Iota paint cans: {iota.x:.2f}")
    print(f"Lambda paint cans: {lambda_.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

