
import gurobi

def solve_paint_mixture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Iota", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="Lambda", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(8 * x1 + 12 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(3 * x1 + 5 * x2 >= 10, name="Dye")
    model.addConstr(5 * x1 + 8 * x2 >= 12, name="Thinner")
    model.addConstr(6 * x1 + 3 * x2 >= 15, name="Oil")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_paint_mixture_problem()
