
import gurobipy as gp

# Create a new model
m = gp.Model("shoe_production")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="black_shoes") # Number of black shoes
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="blue_shoes")  # Number of blue shoes


# Set objective function
m.setObjective(-3 * x1 + 6 * x2, gp.GRB.MAXIMIZE)  # Maximize profit

# Add constraints
m.addConstr(x1 <= 150, "max_black")
m.addConstr(x2 <= 100, "max_blue")
m.addConstr(x1 >= 75, "min_black")
m.addConstr(x2 >= 60, "min_blue")
m.addConstr(x1 + x2 >= 125, "min_total")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of black shoes to produce: {x1.x}")
    print(f"Number of blue shoes to produce: {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

