
from gurobipy import *

# Create a new model
m = Model("Shoe_Production")

# Define variables
x1 = m.addVar(lb=75, ub=150, vtype=GRB.INTEGER, name="black_shoes")
x2 = m.addVar(lb=60, ub=100, vtype=GRB.INTEGER, name="blue_shoes")

# Set the objective function
m.setObjective(-3*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 150, "max_black_shoes")
m.addConstr(x2 <= 100, "max_blue_shoes")
m.addConstr(x1 >= 75, "min_black_shoes_demand")
m.addConstr(x2 >= 60, "min_blue_shoes_demand")
m.addConstr(x1 + x2 >= 125, "total_min_shoes")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Black shoes: {x1.x}")
    print(f"Blue shoes: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
