
import gurobi

def solve_shoe_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=150, name="black_shoes")
    x2 = model.addVar(lb=0, ub=100, name="blue_shoes")

    # Set bounds according to demand
    x1.lb = 75
    x2.lb = 60

    # Objective function: maximize -3x1 + 6x2
    model.setObjective(-3 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 <= 150, name="black_shoes上限")
    model.addConstr(x2 <= 100, name="blue_shoes上限")
    model.addConstr(x1 >= 75, name="black_shoes下限")
    model.addConstr(x2 >= 60, name="blue_shoes下限")
    model.addConstr(x1 + x2 >= 125, name="total_shoes")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Black shoes: {x1.x}, Blue shoes: {x2.x}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_shoe_problem()
