
import gurobipy as gp

# Create a new model
model = gp.Model("Vehicle Production")

# Create decision variables
minivans = model.addVar(vtype=gp.GRB.CONTINUOUS, name="minivans")
suvs = model.addVar(vtype=gp.GRB.CONTINUOUS, name="suvs")

# Set objective function
model.setObjective(5500 * minivans + 4000 * suvs, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(9 * minivans + 7 * suvs <= 450, "Engineering Time")
model.addConstr(25 * minivans + 25 * suvs <= 1200, "Steel")
model.addConstr(minivans >= 0, "Minivans Non-Negative")
model.addConstr(suvs >= 0, "SUVs Non-Negative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Profit: ${model.objVal:.2f}")
    print(f"Number of Minivans: {minivans.x:.2f}")
    print(f"Number of SUVs: {suvs.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

