
from gurobipy import *

# Create a new model
m = Model("car_production")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="minivans")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="SUVs")

# Set the objective function
m.setObjective(5500*x1 + 4000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 48, "steel_constraint")
m.addConstr(9*x1 + 7*x2 <= 450, "engineering_time_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Minivans to produce: {x1.x}")
    print(f"SUVs to produce: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
