
import gurobi

def solve_vehicle_production():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='minivans', lb=0)
    x2 = model.addVar(name='SUVs', lb=0)

    # Define the objective function
    model.setObjective(5500 * x1 + 4000 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(25 * x1 + 25 * x2 <= 1200, name='steel_constraint')
    model.addConstr(9 * x1 + 7 * x2 <= 450, name='engineering_time_constraint')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production: {x1.x} minivans, {x2.x} SUVs")
        print(f"Max profit: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible")

solve_vehicle_production()
