
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("lucas_farm")

# Create variables
mango = m.addVar(lb=0, name="mango")  # Acres of mango trees
durian = m.addVar(lb=0, name="durian") # Acres of durian trees

# Set objective function
m.setObjective(200 * mango + 300 * durian, GRB.MAXIMIZE)

# Add constraints
m.addConstr(mango + durian <= 150, "land")
m.addConstr(150 * mango + 180 * durian <= 20000, "budget")
m.addConstr(6 * mango + 3 * durian <= 700, "labor")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Plant {mango.x:.2f} acres of mango trees")
    print(f"Plant {durian.x:.2f} acres of durian trees")
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

