
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="mango_trees")
    x2 = model.addVar(lb=0, name="durian_trees")

    # Objective function: Maximize 50x1 + 120x2
    model.setObjective(50*x1 + 120*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(150*x1 + 180*x2 <= 20000, name="budget_constraint")
    model.addConstr(6*x1 + 3*x2 <= 700, name="labor_constraint")
    model.addConstr(x1 + x2 <= 150, name="land_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Mango Trees: {x1.varValue}")
        print(f"Durian Trees: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
