
import gurobipy as gp

# Create a new model
m = gp.Model("fast_food_optimization")

# Create variables
burgers = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="burgers")
sandwiches = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="sandwiches")

# Set objective function
m.setObjective(4.5 * burgers + 5 * sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(burgers >= 100, "min_burgers")
m.addConstr(sandwiches >= 80, "min_sandwiches")
m.addConstr(burgers <= 120, "max_burgers")
m.addConstr(sandwiches <= 100, "max_sandwiches")
m.addConstr(burgers + sandwiches <= 200, "max_total")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of burgers: {burgers.x}")
    print(f"Number of sandwiches: {sandwiches.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

