
from gurobipy import *

# Create a new model
m = Model("FastFoodProfit")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="burgers")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="sandwiches")

# Set the objective function
m.setObjective(4.5*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 100, "min_burgers")
m.addConstr(x2 >= 80, "min_sandwiches")
m.addConstr(x1 <= 120, "max_burgers")
m.addConstr(x2 <= 100, "max_sandwiches")
m.addConstr(x1 + x2 <= 200, "total_items")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Burgers: {x1.x}")
    print(f"Sandwiches: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
