
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="burgers")
    x2 = model.addVar(lb=0, name="sandwiches")

    # Set the objective function
    model.setObjective(4.5 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 >= 100, name="min_burgers")
    model.addConstr(x2 >= 80, name="min_sandwiches")
    model.addConstr(x1 <= 120, name="max_burgers")
    model.addConstr(x2 <= 100, name="max_sandwiches")
    model.addConstr(x1 + x2 <= 200, name="total_items")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Burgers: {x1.varValue}")
        print(f"Sandwiches: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
