
import gurobipy as gp

# Create a new model
m = gp.Model("plush_toy_production")

# Create variables
bears = m.addVar(vtype=gp.GRB.INTEGER, name="bears")
dogs = m.addVar(vtype=gp.GRB.INTEGER, name="dogs")

# Set objective function
m.setObjective(4 * bears + 5 * dogs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * bears + 12 * dogs <= 1000, "time_constraint")
m.addConstr(bears >= 2 * dogs, "bear_demand_constraint")
m.addConstr(bears >=0, "non_negativity_bears")
m.addConstr(dogs >=0, "non_negativity_dogs")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of bears to produce: {bears.x}")
    print(f"Number of dogs to produce: {dogs.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

