
from gurobipy import *

# Create a model
m = Model("plush_toys")

# Define variables
x1 = m.addVar(name="bear_plush_toys", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="dog_plush_toys", vtype=GRB.INTEGER, lb=0)

# Set objective function
m.setObjective(4*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 12*x2 <= 1000, name="time_constraint")
m.addConstr(x1 >= 2*x2, name="production_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bear plush toys: {x1.x}")
    print(f"Number of dog plush toys: {x2.x}")
    print(f"Maximum profit: ${4*x1.x + 5*x2.x}")
else:
    print("No optimal solution found")
