
import gurobi

def solve_plush_toys_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # bear plush toys
    x2 = model.addVar(name='x2', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # dog plush toys

    # Set the objective function
    model.setObjective(4 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * x1 + 12 * x2 <= 1000)  # time constraint
    model.addConstr(x1 >= 2 * x2)  # bear vs dog constraint

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    else:
        print("The problem is infeasible")

solve_plush_toys_problem()
