
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("steel_shop")

    # Create variables
    fences = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fences")
    doors = m.addVar(vtype=gp.GRB.CONTINUOUS, name="doors")


    # Set objective function
    m.setObjective(200 * fences + 100 * doors, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * fences + 5 * doors <= 400, "stainless_steel_constraint")
    m.addConstr(10 * fences + 1 * doors <= 500, "aluminum_constraint")
    m.addConstr(fences >= 0, "fences_nonnegative")
    m.addConstr(doors >= 0, "doors_nonnegative")


    # Optimize model
    m.optimize()

    # Print results
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))

    print('Obj: %g' % m.objVal)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

