
from gurobipy import *

# Create a new model
m = Model("Steel_Shop_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="fences", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="doors", lb=0)

# Set the objective function
m.setObjective(200*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 5*x2 <= 400, "stainless_steel_constraint")
m.addConstr(10*x1 + x2 <= 500, "aluminum_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of fences: {x1.x}")
    print(f"Number of doors: {x2.x}")
    print(f"Total profit: ${200*x1.x + 100*x2.x:.2f}")
else:
    print("No optimal solution found.")
