
import gurobipy as gp

# Create a new model
model = gp.Model("SteelShop")

# Define variables
x1 = model.addVar(name="Fences", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="Doors", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(200*x1 + 100*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2*x1 + 5*x2 <= 400, name="StainlessSteelConstraint")
model.addConstr(10*x1 + x2 <= 500, name="AluminumConstraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Fences = {x1.varValue}, Doors = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
