
import gurobipy as gp

# Create a new model
model = gp.Model("PrintingOptimization")

# Create decision variables
books = model.addVar(vtype=gp.GRB.CONTINUOUS, name="books")  # Number of books
magazines = model.addVar(vtype=gp.GRB.CONTINUOUS, name="magazines")  # Number of magazines

# Set the objective function
model.setObjective(5 * books + 8 * magazines, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10 * books + 20 * magazines <= 5000, "PrintingTime")  # Printing time constraint
model.addConstr(5 * books + 3 * magazines <= 2000, "BindingTime")  # Binding time constraint
model.addConstr(books >= 0, "BooksNonNegative")  # Non-negativity constraint for books
model.addConstr(magazines >= 0, "MagazinesNonNegative")  # Non-negativity constraint for magazines

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of books to print: {books.x:.2f}")
    print(f"Number of magazines to print: {magazines.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

