
from gurobipy import *

# Create a model
m = Model("Printing_Company_Profit")

# Define variables
x1 = m.addVar(name='books', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='magazines', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(5*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 20*x2 <= 5000, name='printing_time')
m.addConstr(5*x1 + 3*x2 <= 2000, name='binding_time')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
