
import gurobi

def solve_printing_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='books', lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name='magazines', lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(5 * x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 20 * x2 <= 5000, name='printing_time')
    model.addConstr(5 * x1 + 3 * x2 <= 2000, name='binding_time')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: books = {x1.varValue}, magazines = {x2.varValue}")
        print(f"Max profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_printing_problem()
