
import gurobipy as gp

# Create a new model
m = gp.Model("BerryMix")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bags_of_A") # Bags of berry mix A
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bags_of_B") # Bags of berry mix B


# Set objective function
m.setObjective(5*x1 + 3*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(30*x1 + 20*x2 >= 150, "blueberry_constraint")
m.addConstr(45*x1 + 15*x2 >= 125, "blackberry_constraint")
m.addConstr(x1 >= 0, "nonnegativity_A")
m.addConstr(x2 >= 0, "nonnegativity_B")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Bags of berry mix A: {x1.x}")
    print(f"Bags of berry mix B: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

