
from gurobipy import *

# Create a new model
m = Model("Berry_Mix_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="berry_mix_A", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="berry_mix_B", lb=0)

# Set the objective function
m.setObjective(5*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(30*x1 + 20*x2 >= 150, "blueberries_constraint")
m.addConstr(45*x1 + 15*x2 >= 125, "blackberries_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bags of Berry Mix A: {x1.x}")
    print(f"Number of bags of Berry Mix B: {x2.x}")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
