
import gurobipy as gp

# Create a new model
model = gp.Model("berry_mix")

# Define variables
x1 = model.addVar(name="berry_mix_A", lb=0, vtype=gp.GRB.INTEGER)  # Number of bags of berry mix A
x2 = model.addVar(name="berry_mix_B", lb=0, vtype=gp.GRB.INTEGER)  # Number of bags of berry mix B

# Objective function: Minimize cost
model.setObjective(5 * x1 + 3 * x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(30 * x1 + 20 * x2 >= 150, name="blueberries_constraint")
model.addConstr(45 * x1 + 15 * x2 >= 125, name="blackberries_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Minimum cost: ${5 * x1.varValue + 3 * x2.varValue}")
else:
    print("No optimal solution found.")
