
import gurobipy as gp

# Create a new model
m = gp.Model("fish_profit")

# Create variables
small_fish = m.addVar(vtype=gp.GRB.CONTINUOUS, name="small_fish")  # Number of small fish
large_fish = m.addVar(vtype=gp.GRB.CONTINUOUS, name="large_fish")  # Number of large fish


# Set objective function
m.setObjective(8 * small_fish + 11 * large_fish, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * small_fish + 10 * large_fish <= 500, "cleaning_time")
m.addConstr(10 * small_fish + 15 * large_fish <= 700, "cutting_time")
m.addConstr(small_fish >= 0, "small_fish_nonnegative")  # Ensure non-negative number of fish
m.addConstr(large_fish >= 0, "large_fish_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of small fish: {small_fish.x}")
    print(f"Number of large fish: {large_fish.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

