
from gurobipy import *

# Create a new model
m = Model("Fish_Cleaning_and_Cutting")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="small_fish", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="large_fish", lb=0)

# Set the objective function
m.setObjective(8*x1 + 11*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 10*x2 <= 500, "cleaning_time")
m.addConstr(10*x1 + 15*x2 <= 700, "cutting_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of small fish: {x1.x}")
    print(f"Number of large fish: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
