
import gurobipy as gp

def solve_fish_problem():
    # Create a new model
    model = gp.Model("fish_problem")

    # Define variables
    x1 = model.addVar(name="small_fish", lb=0, vtype=gp.GRB.INTEGER)  # Number of small fish
    x2 = model.addVar(name="large_fish", lb=0, vtype=gp.GRB.INTEGER)  # Number of large fish

    # Objective function: Maximize profit
    model.setObjective(8*x1 + 11*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 10*x2 <= 500, name="cleaning_time")  # Cleaning time constraint
    model.addConstr(10*x1 + 15*x2 <= 700, name="cutting_time")  # Cutting time constraint

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.X}, {x2.varName} = {x2.X}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_fish_problem()
