
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("CaMilk_Production")

# Create variables
muffins = m.addVar(vtype=GRB.INTEGER, name="muffins")
milk_cakes = m.addVar(vtype=GRB.INTEGER, name="milk_cakes")

# Set objective function
m.setObjective(6.5 * muffins + 8.5 * milk_cakes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * muffins + 100 * milk_cakes <= 25000, "Milk_Constraint")
m.addConstr(milk_cakes >= 2 * muffins, "Demand_Constraint")
m.addConstr(muffins >= 50, "Minimum_Muffins")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of muffins: {muffins.x}")
    print(f"Number of milk cakes: {milk_cakes.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

