
from gurobipy import *

# Create a new model
m = Model("CaMilk_Optimization")

# Define variables
x1 = m.addVar(name="muffins", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="milk_cakes", vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(6.5*x1 + 8.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x2 >= 2*x1, name="at_least_twice_as_many_milk_cakes")
m.addConstr(x1 >= 50, name="at_least_50_muffins")
m.addConstr(15*x1 + 100*x2 <= 25000, name="total_milk_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
