
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="muffins")
    x2 = model.addVar(lb=0, name="milk_cakes")

    # Set the objective function
    model.setObjective(6.5 * x1 + 8.5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * x1 + 100 * x2 <= 25000, name="milk_availability")
    model.addConstr(x2 >= 2 * x1, name="muffin_to_milk_cake_ratio")
    model.addConstr(x1 >= 50, name="minimum_muffin_production")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of muffins: {x1.varValue}")
        print(f"Number of milk cakes: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
