
import gurobipy as gp

# Create a new model
m = gp.Model("labor_camp_diet")

# Create variables
soup = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="soup")  # Cans of soup
sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sandwiches")  # Number of sandwiches

# Set objective function: Minimize cost
m.setObjective(1 * soup + 3 * sandwiches, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(200 * soup + 250 * sandwiches >= 2000, "calories")  # Calorie constraint
m.addConstr(5 * soup + 10 * sandwiches >= 100, "protein")  # Protein constraint
m.addConstr(4 * soup + 15 * sandwiches >= 100, "carbs")  # Carb constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Cans of soup: {soup.x:.2f}")
    print(f"Sandwiches: {sandwiches.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

