
from gurobipy import *

# Create a new model
m = Model("Labor_Camp_Diet")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cans_of_soup")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sandwiches")

# Set the objective function
m.setObjective(1*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(200*x1 + 250*x2 >= 2000, "calories")
m.addConstr(5*x1 + 10*x2 >= 100, "protein")
m.addConstr(4*x1 + 15*x2 >= 100, "carbs")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of cans of soup: {x1.x}")
    print(f"Number of sandwiches: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
