
import gurobipy as gp

# Create a new model
model = gp.Model("diet_problem")

# Define variables
x1 = model.addVar(name="soup", lb=0)  # cans of soup
x2 = model.addVar(name="sandwich", lb=0)  # sandwiches

# Objective function: minimize total cost
model.setObjective(1*x1 + 3*x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(200*x1 + 250*x2 >= 2000, name="calories")
model.addConstr(5*x1 + 10*x2 >= 100, name="protein")
model.addConstr(4*x1 + 15*x2 >= 100, name="carbs")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
