
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("GrusCreation_Staffing")

# Create variables
researchers = m.addVar(lb=0, vtype=GRB.INTEGER, name="researchers")
developers = m.addVar(lb=0, vtype=GRB.INTEGER, name="developers")

# Set objective function
m.setObjective(2500 * researchers + 1500 * developers, GRB.MINIMIZE)

# Add constraints
m.addConstr(researchers + developers >= 50, "Total_Staff")
m.addConstr(developers >= 30, "Min_Developers")
m.addConstr(researchers >= (1/3) * developers, "Researcher_Developer_Ratio")
m.addConstr(2500 * researchers + 1500 * developers <= 250000, "Max_Payroll")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Researchers: {researchers.x}")
    print(f"Number of Developers: {developers.x}")
    print(f"Total Weekly Payroll: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

