
from gurobipy import *

# Create a new model
m = Model("GrusCreation_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="researchers")
x2 = m.addVar(vtype=GRB.INTEGER, name="developers")

# Set the objective function
m.setObjective(2500*x1 + 1500*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 50, "total_workers")
m.addConstr(x2 >= 30, "min_developers")
m.addConstr(x1 >= (1/3)*x2, "researcher_to_developer_ratio")
m.addConstr(2500*x1 + 1500*x2 <= 250000, "max_payroll")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of researchers: {x1.x}")
    print(f"Number of developers: {x2.x}")
    print(f"Total wages: ${2500*x1.x + 1500*x2.x:.2f}")
else:
    print("No optimal solution found")
