
import gurobipy as gp

# Create a new model
model = gp.Model("GrusCreation_Firm")

# Define variables
x1 = model.addVar(name="researchers", vtype=gp.GRB.INTEGER)  # Number of researchers
x2 = model.addVar(name="developers", vtype=gp.GRB.INTEGER)  # Number of developers

# Objective function: Minimize weekly payroll
model.setObjective(2500*x1 + 1500*x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(x1 + x2 >= 50, name="total_workers")  # At least 50 workers
model.addConstr(x2 >= 30, name="min_developers")  # At least 30 developers
model.addConstr(x1 >= (1/3)*x2, name="researcher_to_developer_ratio")  # Researchers at least a third of developers
model.addConstr(2500*x1 + 1500*x2 <= 250000, name="max_payroll")  # Maximum weekly payroll

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Number of researchers: {x1.varValue}")
    print(f"Number of developers: {x2.varValue}")
    print(f"Minimum weekly payroll: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
