
import gurobipy as gp

# Create a new model
model = gp.Model("battery_optimization")

# Create variables
aa_batteries = model.addVar(vtype=gp.GRB.INTEGER, name="aa_batteries")
d_batteries = model.addVar(vtype=gp.GRB.INTEGER, name="d_batteries")

# Set objective function
model.setObjective(0.5 * aa_batteries + 1 * d_batteries, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(1 * aa_batteries + 3 * d_batteries <= 1000, "budget_constraint")
model.addConstr(aa_batteries + d_batteries <= 1000, "demand_constraint")
model.addConstr(aa_batteries >= 0, "aa_non_negativity")
model.addConstr(d_batteries >= 0, "d_non_negativity")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {model.objVal}")
    print(f"Number of AA batteries: {aa_batteries.x}")
    print(f"Number of D batteries: {d_batteries.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

