
from gurobipy import *

# Create a new model
m = Model("Battery_Profit_Optimization")

# Define variables
x1 = m.addVar(name="AA_Batteries", lb=0)  # Number of AA batteries
x2 = m.addVar(name="D_Batteries", lb=0)   # Number of D batteries

# Set the objective function
m.setObjective(0.5*x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 3*x2 <= 1000, name="Budget_Constraint")
m.addConstr(x1 + x2 <= 1000, name="Demand_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of AA batteries: {x1.x}")
    print(f"Number of D batteries: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
