
import gurobi as gp

# Define the model
model = gp.Model("Battery_Store_Optimization")

# Define the variables
x1 = model.addVar(name="AA_batteries", lb=0, ub=1000, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="D_batteries", lb=0, ub=1000, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(0.50 * x1 + 1 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(x1 + 3 * x2 <= 1000, name="budget_constraint")
model.addConstr(x1 + x2 <= 1000, name="demand_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"AA batteries: {x1.varValue}")
    print(f"D batteries: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
