
from gurobipy import *

# Create a new model
m = Model("Lisa_Investment")

# Create variables
x1 = m.addVar(lb=0, name="NFTs")
x2 = m.addVar(lb=0, name="CryptoCurrency")

# Set the objective function
m.setObjective(0.30*x1 + 0.40*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 5000, "Total Investment")
m.addConstr(x1 >= 0.25*(x1 + x2), "Minimum NFTs")
m.addConstr(x2 >= 2300, "Minimum CryptoCurrency")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Amount invested in NFTs: {x1.x}")
    print(f"Amount invested in crypto-currency: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found.")

