
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Problem")

# Define variables
x1 = model.addVar(name="NFTs", lb=0)  # Amount invested in NFTs
x2 = model.addVar(name="crypto-currency", lb=0)  # Amount invested in crypto-currency

# Objective function: Maximize profit
model.setObjective(0.30*x1 + 0.40*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 5000, name="Total_Investment")  # Total investment up to $5000
model.addConstr(x1 >= 0.25*(x1 + x2), name="NFTs_Min_Investment")  # Minimum of 25% in NFTs
model.addConstr(x2 >= 2300, name="crypto-currency_Min_Investment")  # At least $2300 in crypto-currency

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Amount invested in NFTs: ${x1.varValue:.2f}")
    print(f"Amount invested in crypto-currency: ${x2.varValue:.2f}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
