
import gurobipy as gp

# Create a new model
model = gp.Model("console_production")

# Create variables
premium = model.addVar(vtype=gp.GRB.CONTINUOUS, name="premium")  # Number of premium consoles
regular = model.addVar(vtype=gp.GRB.CONTINUOUS, name="regular")  # Number of regular consoles

# Set objective function
model.setObjective(100 * premium + 75 * regular, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * premium + 10 * regular <= 10000, "testing_time")  # Testing time constraint
model.addConstr(3 * premium + 2 * regular <= 1500, "ic_chips")  # IC chip constraint
model.addConstr(premium >= 0, "premium_nonnegative") # Non-negativity constraint
model.addConstr(regular >= 0, "regular_nonnegative") # Non-negativity constraint


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of premium consoles: {premium.x:.2f}")
    print(f"Number of regular consoles: {regular.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

