
from gurobipy import *

# Create a new model
model = Model("Console_Production")

# Add variables
x1 = model.addVar(name="premium_consoles", vtype=GRB.INTEGER, lb=0)
x2 = model.addVar(name="regular_consoles", vtype=GRB.INTEGER, lb=0)

# Set the objective function
model.setObjective(100*x1 + 75*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 10*x2 <= 10000, name="testing_time")
model.addConstr(3*x1 + 2*x2 <= 1500, name="ic_chips")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Premium consoles: {x1.x}")
    print(f"Regular consoles: {x2.x}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
