
import gurobipy as gp

# Create a new model
model = gp.Model("console_production")

# Define variables
x1 = model.addVar(name="premium_consoles", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="regular_consoles", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(100*x1 + 75*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(20*x1 + 10*x2 <= 10000, name="testing_time")
model.addConstr(3*x1 + 2*x2 <= 1500, name="ic_chips")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of premium consoles: {x1.varValue}")
    print(f"Number of regular consoles: {x2.varValue}")
    print(f"Max profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
