
import gurobipy as gp

# Create a new model
m = gp.Model("team_optimization")

# Create variables
small_teams = m.addVar(vtype=gp.GRB.INTEGER, name="small_teams")
large_teams = m.addVar(vtype=gp.GRB.INTEGER, name="large_teams")

# Set objective function
m.setObjective(5000 * small_teams + 15000 * large_teams, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * small_teams + 20 * large_teams >= 100, "tasks_constraint")
m.addConstr(1 * small_teams + 3 * large_teams <= 10, "supervisors_constraint")
m.addConstr(small_teams >= 0, "small_teams_nonnegative")
m.addConstr(large_teams >= 0, "large_teams_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Number of small teams: {small_teams.x}")
    print(f"Number of large teams: {large_teams.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

