
from gurobipy import *

# Create a new model
m = Model("Team_Formation")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="small_teams")
x2 = m.addVar(vtype=GRB.INTEGER, name="large_teams")

# Set the objective function
m.setObjective(5000*x1 + 15000*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x1 + 20*x2 >= 100, "tasks")
m.addConstr(x1 + 3*x2 <= 10, "supervisors")
m.addConstr(x1 >= 0, "non_neg_small_teams")
m.addConstr(x2 >= 0, "non_neg_large_teams")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of small teams: {x1.x}")
    print(f"Number of large teams: {x2.x}")
    print(f"Total cost: ${5000*x1.x + 15000*x2.x}")
else:
    print("No optimal solution found")
