
import gurobipy as gp

# Create a new model
model = gp.Model("Team_Optimization")

# Define the variables
x1 = model.addVar(name="small_teams", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="large_teams", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(5000*x1 + 15000*x2, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(8*x1 + 20*x2 >= 100, name="tasks_per_hour")
model.addConstr(x1 + 3*x2 <= 10, name="supervisors")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: small teams = {x1.varValue}, large teams = {x2.varValue}")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
