
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
solar_investment = m.addVar(name="solar_investment")
wind_investment = m.addVar(name="wind_investment")

# Set objective function
m.setObjective(0.06 * solar_investment + 0.05 * wind_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(solar_investment + wind_investment <= 50000, "total_investment")
m.addConstr(wind_investment >= 0.7 * (solar_investment + wind_investment), "min_wind_investment")
m.addConstr(solar_investment <= 0.2 * (solar_investment + wind_investment), "max_solar_investment")
m.addConstr(solar_investment >= 0, "non_negative_solar")
m.addConstr(wind_investment >= 0, "non_negative_wind")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in solar: {solar_investment.x}")
    print(f"Optimal investment in wind: {wind_investment.x}")
    print(f"Optimal return: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

