
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="solar_energy_investment")
x2 = m.addVar(lb=0, name="wind_energy_investment")

# Set the objective function
m.setObjective(0.06*x1 + 0.05*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 50000, "total_investment")
m.addConstr(x2 >= 0.7*50000, "minimum_wind_energy_investment")
m.addConstr(x1 <= 0.2*50000, "maximum_solar_energy_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in solar energy: ${x1.x:.2f}")
    print(f"Amount invested in wind energy: ${x2.x:.2f}")
    print(f"Maximum return: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
